# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Apply a composed look to a SharePoint site 
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to SharePoint site
$webUrl = "http://sharepoint/site"

# Relative URL to color palette
$paletteUrl = "/_catalogs/theme/15/Palette015.spcolor"

# Relative URL to font scheme
$fontUrl = "/_catalogs/theme/15/fontscheme001.spfont"

# Relative URL for background image
$backgroundUrl = "/images/background.png"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site
$web = Get-SPWeb $webUrl

# Apply the composed look elements to the site, specify false to place the generated theme files within the site
$web.ApplyTheme($paletteUrl, $fontUrl, $backgroundUrl, $false)

# Update the site
$web.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 